package com.ptteng.yi.etl;

import com.ptteng.yi.etl.util.Calculation;
import com.ptteng.yi.etl.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.AppointOrder;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.service.AppointOrderService;
import com.ptteng.yi.nucleus.service.CoachService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.*;

public class CoachAppraiseEtl {
    private static final Log log = LogFactory.getLog(CoachAppraiseEtl.class);
    /**
     * @Fields:空转任务间隔休息毫秒数
     */
    private static final long SLEEP_MILLISECOND = 14400000;

    private Long interval = 2000L;

    private AppointOrderService appointOrderService;

    private CoachService coachService;

    public CoachAppraiseEtl() {
        super();
    }

    public void process() throws InterruptedException {
        while (true) {
            try {
                test();
                Thread.sleep(interval);
            } catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(interval);
                log.error("process check expire-user error ,sleep " + t.getMessage());
            }
        }
    }

    public void test(){
        try {
            List<Long> cids = coachService.getCoachIds(0,Integer.MAX_VALUE);
            List<Coach> coachList = coachService.getObjectsByIds(cids);
            for (Coach coach:coachList){
                Map<String, Object> conditions = new HashMap<>();
                conditions = DynamicUtil.getOrderListByCoach(coach.getId());
                List<Long> aids = appointOrderService.getIdsByDynamicCondition(AppointOrder.class,conditions,0,Integer.MAX_VALUE);
                List<AppointOrder> appointOrderList = appointOrderService.getObjectsByIds(aids);
                Double num = 0.0;
                Double score = 0.0;
                for(AppointOrder appointOrder:appointOrderList){
                    if(DataUtils.isNotNullOrEmpty(appointOrder.getScore())){
                        Double s = Double.parseDouble(appointOrder.getScore());
                        num = num+1.0;
                        score = score + s;
                    }
                }
                log.info("score " + score + "    num::" + num);
                if(score.equals(0.0) || num.equals(0.0)){
                    coach.setScore(score.toString());
                }else {
                    score = Calculation.div(score,num,1);
                    log.info("教练id  : " + coach.getId() + "    平均分  ： " + score);
                    coach.setScore(score.toString());
                }
                coachService.update(coach);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
        }
    }

    public AppointOrderService getAppointOrderService() {
        return appointOrderService;
    }

    public void setAppointOrderService(AppointOrderService appointOrderService) {
        this.appointOrderService = appointOrderService;
    }
    public CoachService getCoachService() {
        return coachService;
    }

    public void setCoachService(CoachService coachService) {
        this.coachService = coachService;
    }

    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

}
